<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsignmentsTable extends Migration {

	public function up()
	{
		Schema::create('consignments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->string('code', 255);
			$table->string('status', 255);
			$table->integer('packages_count');
			$table->datetime('shipped_date');
			$table->datetime('delivered_date');
			$table->string('courier__partner', 255);
			$table->string('tracking_number', 255);
			$table->string('location', 255);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('consignments');
	}
}