<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('title');
			$table->text('body');
			$table->enum('status', array('draft', 'published'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}