<?php

namespace App;

class DOCTOR extends Eloquent {

	protected $table = 'DOCTORS';
	public $timestamps = false;
	protected $fillable = array('PRICE', 'DISCOUNT_NEXT_INTERVIEW', 'CV', 'STAFF_ID');

	public function PeriodWorkDR()
	{
		return $this->hasMany('App\PERIOD_WORK_DR', 'DOCTOR_ID', 'ID');
	}

	public function Reservation()
	{
		return $this->hasMany('App\BOOKING', 'DOCTOR_ID', 'ID');
	}

	public function MedicalRecord()
	{
		return $this->hasMany('App\MEDICAL_RECORD', 'DOCTOR_ID', 'ID');
	}

	public function RequiredTreatment()
	{
		return $this->hasManyThrough('App\NAME_OF_TREATMENT', 'App\MEDICAL_RECORD', 'DOCTOR_ID', 'MEDICAL_RECORD_ID', 'ID', 'ID');
	}

	public function RequiredAnalysis()
	{
		return $this->hasManyThrough('App\REQUIRED_ANALYZE', 'App\MEDICAL_RECORD', 'DOCTOR_ID', 'MEDICAL_RECORD_ID', 'ID', 'ID');
	}

	public function PositiveDisease()
	{
		return $this->hasManyThrough('App\POSITIVE_DISEASE', 'App\MEDICAL_RECORD', 'DOCTOR_ID', 'MEDICAL_RECORD_ID', 'ID', 'ID');
	}

	public function TypeOfDisease()
	{
		return $this->hasMany('App\TYPE_OF_DISEASE', 'DOCTOR_ID', 'ID');
	}

	public function NameOfTreatment()
	{
		return $this->hasMany('App\NAME_OF_TREATMENT', 'DOCTOR_ID', 'ID');
	}

	public function Staff()
	{
		return $this->belongsTo('App\Staff', 'STAFF_ID', 'ID');
	}

}