<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyAgencyTable extends Migration {

	public function up()
	{
		Schema::create('company_agency', function(Blueprint $table) {
			$table->increments('id');
			$table->string('company_agency_name', 255)->index();
			$table->mediumText('company_agency_address')->nullable()->index();
			$table->string('company_agency_state', 255)->index();
			$table->string('company_agency_city', 255)->index();
			$table->string('company_agency_pincode', 255)->index();
			$table->string('company_agency_contact_number_1', 255)->index();
			$table->string('company_agency_contact_number_2', 255)->index();
			$table->string('company_agency_contact_number_3');
			$table->string('company_agency_fax_number_1', 255)->nullable()->index();
			$table->string('company_agency_fax_number_2', 255)->nullable()->index();
			$table->string('company_agency_website', 255)->nullable()->index();
			$table->tinyInteger('is_active')->index()->default('1');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('company_agency');
	}
}