<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobPostingTable extends Migration {

	public function up()
	{
		Schema::create('job_posting', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->mediumText('job_title')->index();
			$table->string('job_profession', 255)->index();
			$table->string('job_location_state', 255)->index();
			$table->string('job_location_city', 255)->index();
			$table->char('job_location_pincode', 10)->index();
			$table->date('job_post_start_date')->index();
			$table->date('job_post_end_date')->index();
			$table->integer('total_vacancy')->index();
			$table->tinyInteger('status')->index()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('job_posting');
	}
}