<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Watchlist extends Model 
{

    protected $table = 'watchlists';
    public $timestamps = true;
    protected $fillable = array('movie_id', 'user_id', 'is_watched', 'is_favorited');

    public function movie()
    {
        return $this->hasOne('Movie');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}