<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Photo extends Model 
{

    protected $table = 'photos';
    public $timestamps = true;
    protected $fillable = array('user_id', 'photo', 'event_id', 'group_id');

    public function users()
    {
        return $this->belongsTo('Models\User');
    }

    public function events()
    {
        return $this->belongsTo('Models\Event');
    }

    public function groups()
    {
        return $this->belongsTo('Models\Group');
    }

}