<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'number', 'code', 'type', 'experince', 'topics', 'fees', 'about', 'school', 'gender', 'work', 'receive_notification', 'appear_in_search', 'keep_me_posted', 'deactivated', 'locked_my_profile');

	public function activities()
	{
		return $this->belongsToMany('Models\Actvitiy');
	}

}