<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkshopsTable extends Migration {

	public function up()
	{
		Schema::create('workshops', function(Blueprint $table) {
			$table->increments('id');
			$table->string('user_id')->nullable();
			$table->string('name')->nullable();
			$table->string('description')->nullable();
			$table->string('email');
			$table->string('phone')->nullable();
			$table->string('cover')->nullable();
			$table->string('video')->nullable();
			$table->string('category_ids')->nullable();
			$table->string('education')->nullable();
			$table->string('verification')->nullable();
			$table->string('experience');
			$table->string('profile')->nullable();
			$table->string('examples')->nullable();
			$table->string('background')->nullable();
			$table->string('job_name')->nullable();
			$table->string('job_discription')->nullable();
			$table->string('job_category')->nullable();
			$table->string('job_price')->nullable();
			$table->string('files')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('workshops');
	}
}