<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuppliersTable extends Migration {

	public function up()
	{
		Schema::create('suppliers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('supplier_name', 255);
			$table->integer('tel')->nullable();
			$table->string('address', 255)->nullable();
			$table->decimal('balance')->default('0.00');
			$table->integer('user_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('suppliers');
	}
}