<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_store')->unsigned();
			$table->integer('id_brand')->unsigned();
			$table->integer('id_category')->unsigned();
			$table->integer('id_user')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('short_description', 600);
			$table->text('full_description');
			$table->float('base_price', 10,2);
			$table->string('code', 12);
			$table->bigInteger('views_count')->default('0');
			$table->integer('is_actived')->default('1');
			$table->integer('views_counter')->unsigned()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}