<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequirementsRowsTable extends Migration {

	public function up()
	{
		Schema::create('requirements_rows', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('requirement_id')->unsigned();
			$table->integer('analysis_id')->unsigned();
			$table->boolean('required');
			$table->decimal('lower_limit')->nullable();
			$table->decimal('upper_limit')->nullable();
			$table->text('notes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('requirements_rows');
	}
}