<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('unique_code', 'password', 'email', 'first_name', 'last_name', 'avatar', 'is_special_needs', 'special_needs_details', 'is_admin', 'is_developer');

	public function kp()
	{
		return $this->hasMany('User', 'user_id');
	}

	public function ratings()
	{
		return $this->hasMany('Rating', 'user_id');
	}

	public function settings()
	{
		return $this->hasMany('User_Setting', 'user_id');
	}

	public function orders()
	{
		return $this->hasMany('Order', 'user_id');
	}

}