<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreStaffTable extends Migration {

	public function up()
	{
		Schema::create('StoreStaff', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('LODASNo')->nullable();
			$table->string('Firstname', 255);
			$table->string('Lastname', 255);
			$table->date('StartDate')->nullable();
			$table->date('EndDate')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('StoreStaff');
	}
}