<?php

namespace BESTSELLER;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WorkingHours extends Eloquent {

	protected $table = 'WorkingHours';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('CostCenter', 'Month', 'Year', 'HoursType', 'HoursTotal');
	protected $visible = array('CostCenter', 'Month', 'Year', 'HoursType', 'HoursTotal');

	public function CostCenter()
	{
		return $this->belongsTo('BESTSELLER\StoreData', 'CostCenter', 'CostCenter');
	}

}