<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentSectionsTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('content_sections_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('content_section_id')->unsigned()->nullable();
			$table->string('title', 191)->nullable();
			$table->text('content')->nullable();
			$table->string('locale', 100)->unique();
		});
	}

	public function down()
	{
		Schema::drop('content_sections_translations');
	}
}