<?php

namespace Models;

class Setting extends Eloquent {

	protected $table = 'settings';
	public $timestamps = true;
	protected $fillable = array('email', 'logo', 'footer_logo', 'work_time');

	public function translations()
	{
		return $this->hasMany('Models\SettingTranslation', 'setting_id');
	}

	public function phones()
	{
		return $this->morphMany('Models\Setting', 'phoneable', 'phoneable_type', 'phoneable_id');
	}

}