<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->hasMany('User');
    }

    public function actions()
    {
        return $this->hasMany('Group');
    }

    public function discussions()
    {
        return $this->hasMany('Group');
    }

    public function files()
    {
        return $this->hasMany('File');
    }

}