<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Action extends Eloquent {

	protected $table = 'actions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->belongsTo('Group');
	}

	public function votes()
	{
		return $this->morphMany('Vote', 'votable');
	}

}