<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Gasto extends Eloquent {

	protected $table = 'gastos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nombre');
	protected $visible = array('nombre');

	public function info()
	{
		return $this->hasMany('App\Moron\Models\InformacionGasto');
	}

	public function panel()
	{
		return $this->belongsTo('App\Moron\Models\Panel');
	}

}