<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('Reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id');
			$table->integer('user_id');
			$table->timestamps();
			$table->integer('rating');
			$table->text('comment');
			$table->tinyInteger('approved')->default('1');
			$table->tinyInteger('spam')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('Reviews');
	}
}