<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 100)->index();
			$table->string('email', 100)->unique();
			$table->string('password', 100);
			$table->string('first_name', 100)->nullable();
			$table->string('last_name', 100)->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('mobile', 50)->unique()->nullable();
			$table->boolean('status')->index()->default(1);
			$table->integer('current_company')->unsigned()->nullable()->index();
			$table->integer('current_branch')->nullable()->index();
			$table->enum('user_type', array('1', '2', '3', '4', '5'))->index();
			$table->string('lang', 20)->nullable();
			$table->rememberToken('rememberToken');
			$table->softDeletes();
			$table->timestamps();
			$table->datetime('last_login')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}