<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorLocationsTable extends Migration {

	public function up()
	{
		Schema::create('doctor_locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email', 50);
			$table->string('phone', 50);
			$table->string('card_name', 50);
			$table->integer('min_rate');
			$table->integer('max_rate');
			$table->enum('type', array('main', 'additional'));
			$table->integer('doctor_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->string('street', 255);
		});
	}

	public function down()
	{
		Schema::drop('doctor_locations');
	}
}