<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->enum('type', array('test'));
			$table->string('source', 255);
			$table->integer('file_id')->unsigned();
			$table->integer('commentable_id')->unsigned();
			$table->string('commentable_type', 50);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}