<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('bullfile_set', function(Blueprint $table) {
			$table->foreign('bullfile_id')->references('id')->on('bullfiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bullfile_set', function(Blueprint $table) {
			$table->foreign('set_id')->references('id')->on('sets')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bullfile_tag', function(Blueprint $table) {
			$table->foreign('bullfile_id')->references('id')->on('bullfiles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('bullfile_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('thumbnails', function(Blueprint $table) {
			$table->foreign('bullfile_id')->references('id')->on('bullfiles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('storage_files', function(Blueprint $table) {
			$table->foreign('bullfile_id')->references('id')->on('bullfiles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('download_history', function(Blueprint $table) {
			$table->foreign('storage_file_id')->references('id')->on('storage_files')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('download_history', function(Blueprint $table) {
			$table->foreign('rbuser_id')->references('id')->on('download_history')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('bullfile_set', function(Blueprint $table) {
			$table->dropForeign('bullfile_set_bullfile_id_foreign');
		});
		Schema::table('bullfile_set', function(Blueprint $table) {
			$table->dropForeign('bullfile_set_set_id_foreign');
		});
		Schema::table('bullfile_tag', function(Blueprint $table) {
			$table->dropForeign('bullfile_tag_bullfile_id_foreign');
		});
		Schema::table('bullfile_tag', function(Blueprint $table) {
			$table->dropForeign('bullfile_tag_tag_id_foreign');
		});
		Schema::table('thumbnails', function(Blueprint $table) {
			$table->dropForeign('thumbnails_bullfile_id_foreign');
		});
		Schema::table('storage_files', function(Blueprint $table) {
			$table->dropForeign('storage_files_bullfile_id_foreign');
		});
		Schema::table('download_history', function(Blueprint $table) {
			$table->dropForeign('download_history_storage_file_id_foreign');
		});
		Schema::table('download_history', function(Blueprint $table) {
			$table->dropForeign('download_history_rbuser_id_foreign');
		});
	}
}