<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Domain extends Model 
{

    protected $table = 'domain';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'user_name', 'password', 'provider_id');

    public function provider()
    {
        return $this->belongsTo('DomainProvider', 'provider_id');
    }

}