<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Server extends Model 
{

    protected $table = 'server';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('hosting_id', 'user_name', 'password', 'link', 'ip');

    public function hosting()
    {
        return $this->belongsTo('HostingCompany', 'hosting_id');
    }

}