<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->nullable();
			$table->string('name')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->double('total')->nullable();
			$table->string('status')->nullable();
			$table->text('note')->nullable();
			$table->string('link')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}