<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectServiceTable extends Migration {

	public function up()
	{
		Schema::create('project_service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->nullable();
			$table->integer('service_id')->nullable();
			$table->integer('domain_id')->nullable();
			$table->string('server_id')->nullable();
			$table->double('price')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->text('note')->nullable();
			$table->string('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('project_service');
	}
}