<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Field extends Eloquent {

	protected $table = 'field';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'type', 'name_ar');

	public function options()
	{
		return $this->hasMany('FiledOption', 'field_id');
	}

}