<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DomainProvider extends Eloquent {

	protected $table = 'domain_provider';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'user_name', 'password');

	public function domains()
	{
		return $this->hasMany('Domain', 'provider_id');
	}

}