<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FiledOption extends Eloquent {

	protected $table = 'field_option';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('filed_id', 'name_en', 'name_ar');

	public function field()
	{
		return $this->belongsTo('Field', 'field_id');
	}

}