<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoice';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('client_id', 'status', 'payment_method', 'payment_date', 'amount', 'tax', 'total', 'number', 'link');

	public function client()
	{
		return $this->belongsTo('User', 'client_id');
	}

}