<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'service';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'active', 'note');

    public function fields()
    {
        return $this->belongsToMany('Field', 'service_field', 'service_id', 'field_id');
    }

}