<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Teacher extends Model 
{

    protected $table = 'Teacher';
    public $timestamps = true;
    protected $fillable = array('user_id', 'subject_id', 'Academic_qualification', 'Employment_status', 'Payment_type', 'Contract_type', 'The_beginning_of_the_contract', 'End_of_contract', 'number_of_lesson_in_week', 'wages_per_lesson');
    protected $visible = array('user_id', 'subject_id', 'Academic_qualification', 'Employment_status', 'Payment_type', 'Contract_type', 'The_beginning_of_the_contract', 'End_of_contract', 'number_of_lesson_in_week', 'wages_per_lesson');

    public function user()
    {
        return $this->belongsTo('\User', 'user_id');
    }

    public function subject()
    {
        return $this->belongsTo('Subject', 'subject_id');
    }

    public function sessions()
    {
        return $this->hasMany('Class_session', 'teacher_id');
    }

    public function marks()
    {
        return $this->hasMany('Mark', 'teacher_id');
    }

    public function education_contents()
    {
        return $this->hasMany('Eeducational_content', 'teacher_id');
    }

}