<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookLoanTable extends Migration {

	public function up()
	{
		Schema::create('Book_Loan', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('book_id')->unsigned();
			$table->enum('type', array('monthly', 'weekly'));
			$table->enum('status', array('returned', 'unreturned'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Book_Loan');
	}
}