<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('article_type_id')->unsigned()->nullable();
			$table->string('title')->nullable();
			$table->string('subtitle')->nullable();
			$table->string('slug')->unique()->nullable();
			$table->text('short')->nullable();
			$table->text('text')->nullable();
			$table->string('thumb')->nullable();
			$table->string('image')->nullable();
			$table->date('date')->nullable();
			$table->tinyInteger('highlight')->default('0');
			$table->tinyInteger('status')->default('1');
			$table->integer('order')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}