<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseDetailTable extends Migration {

	public function up()
	{
		Schema::create('course_detail', function(Blueprint $table) {
			$table->integer('id')->unsigned();
			$table->string('language_code', 2);
			$table->string('slug')->unique()->nullable();
			$table->string('title');
			$table->string('alternative_title')->nullable();
			$table->text('short')->nullable();
			$table->text('text')->nullable();
			$table->string('duration')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('course_detail');
	}
}