<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Staff extends Eloquent {

	protected $table = 'staff';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('staff_type_id', 'name', 'phone', 'phone_extension', 'email', 'url', 'image');
	protected $visible = array('staff_type_id', 'name', 'phone', 'phone_extension', 'email', 'url', 'image');

	public function type()
	{
		return $this->belongsTo('StaffType');
	}

	public function units()
	{
		return $this->belongsToMany('Unit');
	}

}