<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('expedition', function(Blueprint $table) {
			$table->foreign('expediteur_id')->references('id')->on('client')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->foreign('destinataire_id')->references('id')->on('client')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->foreign('code_agence')->references('code_agence')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->foreign('type')->references('id')->on('typecolis')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->foreign('point_depart')->references('id')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->foreign('point_arrivee')->references('id')->on('agences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('typecolis', function(Blueprint $table) {
			$table->foreign('expedition_id')->references('id')->on('expedition')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('expedition', function(Blueprint $table) {
			$table->dropForeign('expedition_expediteur_id_foreign');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->dropForeign('expedition_destinataire_id_foreign');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->dropForeign('expedition_code_agence_foreign');
		});
		Schema::table('expedition', function(Blueprint $table) {
			$table->dropForeign('expedition_type_foreign');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->dropForeign('package_tracking_point_depart_foreign');
		});
		Schema::table('package_tracking', function(Blueprint $table) {
			$table->dropForeign('package_tracking_point_arrivee_foreign');
		});
		Schema::table('typecolis', function(Blueprint $table) {
			$table->dropForeign('typecolis_expedition_id_foreign');
		});
	}
}