<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductAttributeTable extends Migration {

	public function up()
	{
		Schema::create('productAttribute', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('product_id')->unsigned();
			$table->integer('custom_attributes_id')->unsigned();
			$table->string('attribute_value', 255)->index();
		});
	}

	public function down()
	{
		Schema::drop('productAttribute');
	}
}