<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->integer('plan_id')->nullable();
			$table->integer('avatar_id')->nullable();
			$table->string('avatar_color')->nullable();
			$table->string('image')->nullable();
			$table->date('subscribe')->nullable();
			$table->string('name', 191);
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->string('email', 191)->unique();
			$table->string('password');
			$table->string('instagram')->nullable();
			$table->decimal('weight')->nullable();
			$table->boolean('newsletter')->default(0);
			$table->string('apple_id')->nullable();
			$table->string('facebook_id')->nullable();
			$table->string('google_id')->nullable();
			$table->string('role')->default('customer');
			$table->timestamp('email_verified_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}