<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserWorkoutTable extends Migration {

	public function up()
	{
		Schema::create('user_workout', function(Blueprint $table) {
			$table->increments('id');
			$table->bigIncrements('user_id');
			$table->bigIncrements('workout_id');
			$table->json('data')->nullable();
			$table->tinyInteger('is_complete')->default('0');
			$table->date('date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_workout');
	}
}