<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SpareItem extends Model 
{

    protected $table = 'spare_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'item_name', 'amount', 'unit_id', 'notes');

    public function unit()
    {
        return $this->belongsTo('Unit', 'unit_id');
    }

    public function order()
    {
        return $this->belongsTo('SpareOrder', 'order_id');
    }

}