<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryRecordItemTable extends Migration {

	public function up()
	{
		Schema::create('inventory_record_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('record_id')->nullable();
			$table->integer('item_id')->nullable();
			$table->integer('quantity')->nullable();
			$table->string('type')->nullable();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('inventory_record_item');
	}
}