<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PeriodicItem extends Eloquent {

	protected $table = 'periodic_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('periodic_id', 'item_id', 'progress', 'notes');

	public function item()
	{
		return $this->belongsTo('PeriodicItemData', 'item_id');
	}

	public function periodic()
	{
		return $this->belongsTo('PeriodicMaintenance', 'periodic_id');
	}

}