<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabSellerTable extends Migration {

	public function up()
	{
		Schema::create('tabSeller', function(Blueprint $table) {
			$table->increments('id');
			$table->string('avatar')->nullable();
			$table->string('name');
			$table->string('preferred_language')->default('en');
			$table->string('industry_type');
			$table->string('registration_number');
			$table->string('contact_person')->nullable();
			$table->string('email_id');
			$table->string('contact_no');
			$table->string('phone_no')->nullable();
			$table->string('address');
			$table->string('post_code');
			$table->string('city');
			$table->string('state');
			$table->string('country');
			$table->string('status')->default('Inactive');
			$table->string('requires_change_password');
			$table->string('slug')->nullable();
			$table->decimal('commission', 10,2)->nullable();
			$table->text('description')->nullable();
			$table->decimal('rating', 2,1)->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabSeller');
	}
}