<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabCurrencyTable extends Migration {

	public function up()
	{
		Schema::create('tabCurrency', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code');
			$table->string('status', 10)->default('Active');
			$table->string('name')->nullable();
			$table->string('symbol')->nullable();
			$table->string('country');
			$table->text('description')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tabCurrency');
	}
}