<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabProductCommentsTable extends Migration {

	public function up()
	{
		Schema::create('tabProductComments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('commentor');
			$table->text('comment');
			$table->string('status');
			$table->string('email_id');
			$table->string('user_id')->nullable();
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabProductComments');
	}
}