<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTabProductVariantDetailsTable extends Migration {

	public function up()
	{
		Schema::create('tabProductVariantDetails', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->string('name');
			$table->string('label');
			$table->integer('unit_id')->unsigned();
			$table->decimal('conversion_factor', 10,2);
			$table->decimal('price', 10,2);
			$table->string('status')->default('Active');
			$table->string('owner');
			$table->string('last_updated_by');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('tabProductVariantDetails');
	}
}